//This file is part of LiveCoding1. Copyright (C) 2006  Nicholas M.Collins distributed under the terms of the GNU General Public License full notice in file LiveCoding1.help


//Live Coding

//4 stereo busses as sends to global fx? reverb + others
//some master fx always there- Limiter (and Compressor?)

//all on/off and volume functionality in main mixer

//eventual model is a definite separation of nowstate and planned future state with preview on spare busses

LiveCoding1 {

	var w; //, on , vols, names;
	var n;
	var tracksgroup, <masterfxgroup, mixergroup, limitergroup;
	var <tracks;
	var mixersynth;
	var <tempoclock;
	var <tempocontrol;	//front or hide
	var nextbarstart;
	
	var <running;
	var mixer,limiter;
	
	var swapbutt,swapstate;
	var swapvolbutt,swapvolstate;
	var swaponbutt,swaponstate;
	var presets,presetslid, savebutt, loadbutt,copybutt, copybutt2, copybutt3;
	var newnamecount;
	
	//master volume facility
	//var mvolsynth,mvolbus,mvol, mvoldone;
	
	//for additional controls for fredrik
	var fredrikclocksched;
	
	
	*new {
		arg n=16;
		
		^super.new.initLiveCoding1(n).initUI.initMixer;
	}
	
	initLiveCoding1 { arg numTracks;
		
		n=numTracks;
		
		Font(\Verdana-BoldItalic,10).setDefault;
			
		tempocontrol=LCTempoControl.new;
		
		//used to be Group.new, but then live coding will go at head of Node 1
		
		tracksgroup=Group.tail(Node.basicNew(Server.default,1));
		mixergroup=Group.after(tracksgroup);
		masterfxgroup=Group.after(mixergroup);
		limitergroup==Group.after(masterfxgroup);
		
		tracks= Array.fill(n, {arg i; LCTrack.new(i, tracksgroup)});
		
		//so tracks can pass tempoclock
		tracks.do({arg val; val.owner_(this);});
		
		nextbarstart= 0.0;
		
		running= (); //IdentityDictionary.new;
		
		swapstate=0;
		swaponstate=0;
		swapvolstate=0;
		
		newnamecount=0;
	}
	
	initUI {	
		var backcol, frontcol, rowends;
		var killbutt, fadebutt, allbutt, clearbutt, randbutt, randslid, ftslid;
		
		rowends=(n+1)*20;
		
		w= SCWindow("click nilsonification", Rect(10,720,445,rowends+85),border:true);
		
		//w.alpha_(0.9); //slows redraw and Ui reaction time
		
		backcol= Color.blue(0.7,0.7); //Color.new255(135, 250, 106); //Color.new255(135, 106, 250);
		frontcol= Color.white; //Color.new255(150, 40, 70);
		
		//w.userCanClose_(false);
		//w.view.background_(Color.new255(245, 245, 245,230)); //w.view.background_(Color.new255(13, 106, 250));
		w.view.background = Color.blue; //Gradient(Color.blue,Color.blue(0.2),\v);
		
		//else pause synth- if pausing could have a big list of paused available synths
		SCStaticText(w,Rect(0,0,50,20)).string_("arm").font_(Font.default);
		SCStaticText(w,Rect(50,0,100,20)).string_("targetvol").font_(Font.default);
		SCStaticText(w,Rect(150,0,100,20)).string_("names").font_(Font.default);
		SCStaticText(w,Rect(250,0,50,20)).string_("on").font_(Font.default);
		SCStaticText(w,Rect(300,0,100,20)).string_("volume").font_(Font.default);
		
		tracks.do({arg val, i; val.makeGUI(w, 20*(i+1));});
		
		//function buttons
		
		//kill immediately
		killbutt= SCButton(w, Rect(320,rowends+60, 45, 25)).font_(Font.default);
		killbutt.states= [["kill", frontcol, backcol]]; 
		killbutt.action_({
		
		tracks.do({arg val,i; if(val.armval>0.5, {
		this.kill(val.name);
		//val.kill //was missing update to running before!
		});});
		
		});
		
		//fade immediately
		fadebutt= SCButton(w, Rect(0,rowends, 45, 25)).font_(Font.default);
		fadebutt.states= [["fade", frontcol, backcol]]; 
		fadebutt.action_({
		var time;
		
		time= ftslid.value;
		
		tracks.do({arg val; if(val.armval>0.5, {val.fade(time)});});
		});
		
		//swap at next bar
		swapbutt= SCButton(w, Rect(50,rowends, 45, 25)).font_(Font.default);
		swapbutt.states= [["swap?", frontcol, backcol],["ing", frontcol, backcol]]; 
		swapbutt.action_({
		swapstate=swapbutt.value;
		});
		
		
		//swap at next bar
		swaponbutt= SCButton(w, Rect(100,rowends, 55, 25)).font_(Font.default);
		swaponbutt.states= [["swpon?", frontcol, backcol],["ing", frontcol, backcol]]; 
		swaponbutt.action_({
		swaponstate=swaponbutt.value;
		});
		
		
		//swap at next bar
		swapvolbutt= SCButton(w, Rect(160,rowends, 55, 25)).font_(Font.default);
		swapvolbutt.states= [["swpvol?", frontcol, backcol],["ing", frontcol, backcol]]; 
		swapvolbutt.action_({
		swapvolstate=swapvolbutt.value;
		});
		
		allbutt= SCButton(w, Rect(220,rowends, 40, 25)).font_(Font.default);
		allbutt.states= [["all", frontcol, backcol]]; 
		allbutt.action_({
		tracks.do({arg val; val.armval=1; val.arm.value_(1);});
		});
		
		clearbutt= SCButton(w, Rect(265,rowends, 40, 25)).font_(Font.default);
		clearbutt.states= [["clear", frontcol, backcol]]; 
		clearbutt.action_({
		tracks.do({arg val; val.armval=0; val.arm.value_(0);});
		});
		
		copybutt= SCButton(w, Rect(310,rowends, 50, 25)).font_(Font.default);
		copybutt.states= [["copyon", frontcol, backcol]]; 
		copybutt.action_({
			tracks.do({arg val;
			
			val.armval= val.onstate;
			val.arm.value_(val.armval);
			
			});
		});
		
		copybutt3= SCButton(w, Rect(365,rowends, 50, 25)).font_(Font.default);
		copybutt3.states= [["copyoff", frontcol, backcol]]; 
		copybutt3.action_({
			tracks.do({arg val;
			
			val.armval= 1-(val.onstate);
			val.arm.value_(val.armval);
			
			});
		});
		
		
		copybutt2= SCButton(w, Rect(385,rowends+30, 50, 25)).font_(Font.default);
		copybutt2.states= [["copyvol", frontcol, backcol]]; 
		copybutt2.action_({
			tracks.do({arg val;
			
			val.tarvol= val.currvol;
			val.targetvol.value_(val.tarvol);
			    
			});
		});
		
		
		ftslid= DDSlider(w, Rect(150,rowends+30, 100, 25), "fadetime", 0.0,15.0, 'linear', 0.1, 8.0);
		
		randslid= DDSlider(w, Rect(0,rowends+30, 100, 25), "n", 1,n-1, 'linear', 1, 1);
		
		randbutt= SCButton(w, Rect(105,rowends+30, 40, 25)).font_(Font.default);
		randbutt.states= [["randn", frontcol, backcol]]; 
		randbutt.action_({	
			var temp, num;
			
			num= randslid.value.asInteger;
			
			temp=Array.series(n, 0, 1);
			
			temp=temp.scramble.copyRange(0,num-1);
			
			tracks.do({arg val; val.armval=0; val.arm.value_(0); });
			temp.do({arg val; var tr;
			tr=tracks[val];
			tr.armval=1;
			tr.arm.value_(1); });
			
		});
		
		presets= Array.fill(5,nil);
		presetslid= DDSlider(w, Rect(0,rowends+60, 100, 25), "presets", 0,presets.size-1, 'linear', 1, 0);
		
		savebutt= SCButton(w, Rect(105,rowends+60, 40, 25)).font_(Font.default);
		savebutt.states= [["save", frontcol, backcol]]; 
		savebutt.action_({	
			var which,list;
			
			which= (presetslid.value).round(1.0).asInteger;
			list=List.new;
			tracks.do({arg val; list.add(val.saveState)});
			presets[which]=list.asArray;
		});
		
		loadbutt= SCButton(w, Rect(155,rowends+60, 50, 25)).font_(Font.default);
		loadbutt.states= [["restore", frontcol, backcol]]; 
		loadbutt.action_({	
			var which,list;
			
			which= (presetslid.value).round(1.0).asInteger;
			list=presets[which];
			if(list.notNil,
			{
			tracks.do({arg val,j; val.loadState(list[j])});
			});
			
		});
		
		
	//	mvol= SCSlider(w, Rect(270,rowends+30, 100, 15));
	//	
	//	mvoldone=false;
	//	//poll mvolbus every half second
	//	SystemClock.sched(0.0,{
	//	
	//	mvolbus.get({arg val; 
	//	//[val,val.clip2(1.0)].postln;  
	//	{mvol.value_(val.clip2(1.0))}.defer; });
	//	
	//	if(mvoldone,nil,0.25);
	//	});
		
		w.front;
	}
	
	initMixer {	
		
		//mixer must exist at end of RootNode! 
		
		mixer= SynthDef(\mixer,{
		var ins;
		
		ins=Mix.arFill(n, {arg i; 
		
		//no need since on button pauses synths to silence
		
		//BOTH LAGS USED TO BE 0.01, volbus one made slower for non modulated fades 
		Lag.kr(In.kr(tracks[i].onbus.index,1),0.01)*
		Lag.kr(In.kr(tracks[i].volbus.index,1),0.2)*
		(In.ar(tracks.at(i).bus.index,2))		//may need InFeedback for jitlib support? 
		});
		
		//times by 0.1 (-20dB) to avoid overload and limiter pushing, might make this 0.3 (-10dB) 
		Out.ar(0,0.3*ins);
		//Out.ar(0,Limiter.ar(0.3*ins, 0.99));
		
		}).play(mixergroup);
		
		limiter= SynthDef(\LC1limiter,{
		
		//times by 0.1 (-20dB) to avoid overload and limiter pushing, might make this 0.3 (-10dB) 
		ReplaceOut.ar(0,Limiter.ar(In.ar(0,2), 0.99));
		
		}).play(limitergroup);
		
		
		//mvolbus=Bus.control(Server.default,1);
	//	
	//	mvolsynth= SynthDef(\mvolsynth,{
	//	
	//	//Integrator.ar(,0.99)
	//	Out.kr(mvolbus.index,0.5*Mix(In.ar(0,2)).abs);
	//	
	//	}).play(mixergroup,addAction:\addToTail);
	//	
	}
	
	
	stop {
		
		//mvoldone=true; //stop polling volume
		
		tempocontrol.stop;
		//"tempocontrol stopped".postln;
		
		tracks.do({arg val; val.free;});
		
		//"tracks".postln;
		
		mixer.free;
		limiter.free;
		
		//close LC2DSliderWindow
		thisProcess.interpreter.c.close;
		
		//"mixer".postln;
		
		AppClock.sched(0.5,{w.close; 
		//"appclock".postln;
		
		tracksgroup.free; 
		mixergroup.free;
		masterfxgroup.free;
		});
		
		
	}
	
	//simple for now? note this is quantised now
	run {	
		var startbeat;
		
		tempocontrol.run;
		tempoclock= tempocontrol.tempoclock;
		
		//unify all info on beat position
		//this should keep patterns in check accurate to the beat
		startbeat=0.0; //tempoclock.elapsedBeats.roundUp(1.0);
		
		tempocontrol.nextbar=startbeat;
		tempocontrol.barstart=startbeat;
		
		//essential for beattracking later that tempoclock starts on beat 0.0 
		
		tempoclock.schedAbs(startbeat,{
			
			tempocontrol.update;
			
			//"here".postln;
			
			if(swaponstate==1,{
				swaponstate=0;
				tracks.do({arg val; 
				val.onfunc(val.armval);
				});
				{swaponbutt.value_(0)}.defer;
				
			});
			
			if(swapvolstate==1,{
				swapvolstate=0;
				
				//immediate volume swap
				tracks.do({arg val;
				val.volfunc(val.tarvol); 
				});
				
				//update ui
				{
				tracks.do({arg val;
				val.vol.value_(val.tarvol);
				});
				swapvolbutt.value_(0)}.defer;
				
			});
			
			
			if(swapstate==1,{
				swapstate=0;
				
				//immediate swap
				tracks.do({arg val;
				val.onfunc(val.armval);
				val.volfunc(val.tarvol); 
				});
				
				//update ui at defer rate
				{
				tracks.do({arg val;
				val.vol.value_(val.tarvol);
				});
				swapbutt.value_(0)}.defer;
				
			});
			
			
			//once per bar, bar length can be changing- but not for now if assuming quant works
			4.0
		})
		
	}
	
	//simple solution, iterate through tracks until hit first missing link
	findfree {
		tracks.do({arg val, i; if(val.name.isNil, {^i;}); });
		^nil;
	}
	
	tracksinuse {
		var which;
		
		which=List.new;
		
		tracks.do({arg val, i; if(val.name.notNil, {which.add(i)}); });
		
		^which;
	}
	
	
	//addRequiresDeAllocation for when need a kill function, ie must create additional audiobusses etc
	//use a class with function arguments
	
	killall {
		this.kill(Array.series(n,0,1));
		//Post << "afterkill! "<< running <<nl;
	}
	
	muteall {
		tracks.do({arg val; 
		val.onfunc(0);
		});
	}
	
	kill { arg name;
		var tmp;
		
		
		//but a string is also an arrayed collection! 
		if(name.isKindOf(ArrayedCollection),{
		//array of integer positions to kill off
		name.do({arg val; 
		
		tmp=tracks[val].name;
		
		tracks[val].kill;
		if(tmp.notNil, {
		//tmp.postln;
		
		//Post << "pre kill " << running <<nl;
		running.removeAt(tmp);
		//Post << "post kill " << running <<nl;
		});
		
		});
		},
		{
		tmp= running.at(name);
		
		if(tmp.notNil,
		{
		tracks[tmp].kill; 
		//should clear UI for you?
		
		//Post << "pre kill " << running <<nl;
		running.removeAt(name);
		//Post << "post kill " << running <<nl;
		});
		});
	
	}
	
	addf {
		arg func, vol=0.0, on=1;
		
		this.addnf(nil, func, vol, on);
	}
	
	addnf {arg name, func, vol=0.0, on=1;
		
		name = name ?? {
		newnamecount=newnamecount+1;
		("voice"+(newnamecount.asString)).asSymbol};
		
		this.add(LCO(name,func), vol, on);
		}
		
		addschedf {arg beat=0.0, func, vol= 0.0, on=1;
		
		this.addschednf(beat, nil, func, vol, on);
	}
	
	addschednf {arg beat=0.0, name, func, vol=0.0, on=1;
		
		name = name ?? {
		newnamecount=newnamecount+1;
		("voice"+(newnamecount.asString)).asSymbol};
		
		this.addsched(beat,LCO(name,func), vol, on);
	}
	
	
	//will always be add replace
	//add immediately
	add {arg lco, vol= 0.0, on=1;
	
		var tmp, name;
		
		//allow the passing in of array [name, func]?
		//if(lco.isKindOf(Array),{lco= LCO(lco.at(0),lco.at(1))});
		
		name= lco.name;
		
		this.kill(name);
		
		//now try to add
		
		//must find a place in the UI
		tmp= this.findfree;
		
		if(tmp.notNil,
		{
		//should update UI too
		tracks[tmp].add(lco, vol, on, tempoclock);
		running.add(name->tmp);
		});
		
		//Post << running <<nl;
		//^tmp; //return track number
	}
	
	addsched {arg beat=0.0, lco, vol= 0.0, on=1;
		var delay, now;
		
		now= tempoclock.elapsedBeats;
		delay= ((tempocontrol.nextbar)-(now))+beat; //+0.0001;	//add a slight delay so bar update always precedes cutters! 
		
		//Post << [tempocontrol.nextbar, tempoclock.elapsedBeats, beat, delay] <<nl;
		
		//can give negative or positive start beat relative to the next bar start
		tempoclock.schedAbs(now+delay,{
		
		if(lco.isKindOf(LCObject),{
			this.add(lco, vol, on);
		},{
			lco.value;
		});
		
		nil
		});
		
	}
	
	
	breakf { arg beat=0.0, duration=4.0, func, vol=0.8, keep; 
		
		newnamecount=newnamecount+1;
		
		this.break(beat, duration, LCO(("break"+(newnamecount.asString)).asSymbol, func), vol, keep);
	}
	
	break  { arg beat=0.0, duration=4.0, lco, vol=0.8, keep; 
		var delay, state, off;
		
		delay= (tempocontrol.nextbar-(tempoclock.elapsedBeats))+beat;
		
		//Post << [tempocontrol.nextbar,tempoclock.elapsedBeats,beat,delay]<<nl;
		
		tempoclock.schedAbs(tempoclock.elapsedBeats+delay,{
			
			//store previous onoff button state
			state= Array.fill(n,{arg i;  tracks[i].onstate;});
			
			keep= keep ?? {[]};
			
			off= Array.fill(n,{0});
			
			keep.do({arg i; off[i]=1;});
			
			off.do({arg val,i; if(val<0.5, {
			tracks[i].onfunc(0);
			}); });
			
			this.add(lco, vol, 1);
			
			tempoclock.sched(duration, {
				
				//kill breaker
				
				this.kill(lco.name);
				
				//restore previous onoff button state
				tracks.do({arg val, i; val.onfunc(state.at(i)); });
				
				nil
			});
		});
		
	}
	
	tracksarmed {
		var list;
		
		list=List.new;
		
		tracks.do({arg t,j; if(t.armval==1,{list.add(j);}); });
		^list.asArray;
	}
	
	recover { arg track;
		//needs a pause before reinitialisation because there is a pause in free
		
		tracks[track].free;
		
		SystemClock.sched(0.2,{tracks[track].initLCTrack(tracksgroup)});
	}
	
	//resets everything! (except assumes main global groups are safe- else l.stop.init.run?
	reset {
		
		tracks.do({arg val; val.free;});
		
		SystemClock.sched(0.2,{
			tracks.do({arg val; val.initLCTrack(tracksgroup);});
		});
	
	}
	
	
	//runs a live coding object with an automated fade envelope and kills at the end 
	addenv {arg lco, vol= 0.0, on=1, env;
		var tmp, name;
		var length, calls, callcount, tracknum; 
		var val;
		//var lastval, val;
	//	
	//	lastval=100.neg;
		
		name= lco.name;
		
		this.kill(name);
		
		tmp= this.findfree;
		
		if(tmp.notNil,{
			tracks[tmp].add(lco, vol, on, tempoclock);
			running.add(name->tmp);
			
			//use tmp to schedule 
			if(env.notNil,{
		
				length= env.times.sum;
			
				//10 per second- still modulates, should be a Lag though: see above
				calls= length*10;
			
				callcount=1.neg;
			
				SystemClock.sched(0.0,{
					
					callcount=callcount+1;
					
					val=env.at(callcount*0.1);
				
					if(not(val.equalWithPrecision(tracks[tmp].currvol)),{
					if(callcount%10==0,{
					tracks[tmp].volfunc(val);
					},{
					tracks[tmp].volfuncnoGUIupdate(val);
					});
					});
					
					//lastval=val;
					
					if(callcount<calls, 0.1,{
						
						//kill track
						//l.kill(l.tracks[tracknum].name);
						this.kill(name);
						
						nil
					});
				});
			
			
			});
		
		});
	
	}
	
	
	addenvf { arg func, vol=0.0, on=1, env;
	
		this.addenvnf(nil, func, vol, on, env);
	}
	
	addenvnf {arg name, func, vol=0.0, on=1, env;
		
		name = name ?? {
		newnamecount=newnamecount+1;
		("voice"+(newnamecount.asString)).asSymbol};
		
		this.addenv(LCO(name,func), vol, on, env);
	}
	
	
	tempo {^tempocontrol.tempoclock.tempo}
	
	tempo_ {arg tempo; tempocontrol.settempo(tempo);}

	bus {arg which; ^tracks[which].bus.index}

}